/* 
Written by: Daniel M. German <dmg@csg.uwaterloo.ca>
Date: May 26, 1999 

Demo program for the epscan package. 


*/


#include <stdlib.h>
#include <string.h>
#include <stdio.h>



/* include the declarations for the scanner */

#include "epspscan.h"


/* Read a new order (from the project description)

neworder 101 1101
300 6
601 18
-1

Creates an order #101 by sales rep 1101
with the following items:
6 units of product 300
18 units of product 601

*/

/* Allocate the space needed for the token,
1024 spaces seems long enough */

char TokenStr[1024];
token_type Token;


void Read_Each_Product(int OrderNumber, int SalesRep)
{
  int NumberOfProducts = 0;
  int ProductNumber;
  int NumberOfUnits;
  int Token;
  /* Ok, now we are ready to process each order */

  /* Infinite loop, we read until we get a -1 */
  while (1) {
    printf("Please type the product number followed by the unit number\n");
    Token = Get_Token(TokenStr);
    if ( Token != NUMERIC) {
      /* I got something that does not look like an order */
      printf("Illegal token, please try again \n");
      Reset_Get_Token(); /* Remember to call it after an error */
    }
    else { /* first token read is numeric */
      /* We are in business, we have a number */

      /* Is this the end of orders? */

      if (atoi(TokenStr) == -1) {
        printf("Thanks for your order. I read %d products for order %d by Sales Rep %d\n",
             NumberOfProducts, OrderNumber, SalesRep);
        Reset_Get_Token(); /* We don't care what is after the -1 */
        
        return; /* Exit */
      }
      /* Otherwise we save the product number and read the
         units */
      ProductNumber = atoi(TokenStr);
      if (Get_Token(TokenStr) == NUMERIC) {
        /* We got the number of units */

        NumberOfUnits = atoi(TokenStr);

        /* Now make sure that there is an end of line */
        Token = Get_Token(TokenStr);
        if (Token == END_OF_LINE) {
          NumberOfProducts++;
          printf("Item: %d. You want %d of %d\n", NumberOfProducts,
               NumberOfUnits, ProductNumber );
        } /* We did not get the end of record */
        else {
          /* Error, we got something after the number of units */
          printf("I got garbage at the end [%s]\n");
          Reset_Get_Token(); /* Remember to call it after an error */
        }
      }
      else {
        /* We we expecting number of units but got something else */
        printf("I was hoping to get number of units, but got: [%s]\n");
      }
      
    }
  }
}


int Process_New_Order(void)
{
  /* this functions process a new order, if there is an error, it returns 0
     otherwise, if it succeeds, it returns 1 */

    int OrderNumber;
    int SalesRep;
   

    /* We expect numeric value */

    if (Get_Token(TokenStr) != NUMERIC)
      /* Error */
      return 0;

    /*Save the order number */
    OrderNumber = atoi(TokenStr);


    /* Now get the sales rep, we expect NUMERIC */
    if (Get_Token(TokenStr) != NUMERIC) 
      /* Error */
      return 0;
      
    /* Save sales rep */
      /* Good, we got the sales rep number, save it */
    SalesRep = atoi(TokenStr);

    /* Now we get END OF LINE */
    if (Get_Token(TokenStr) != END_OF_LINE)
      /* Error */
      return 0;
        
    /* So far we have the order number and sales rep */
    printf("We are processing Order: %d by sales rep: %d\n", OrderNumber,
         SalesRep );


    /* Lets now read the orders */

    Read_Each_Product(OrderNumber, SalesRep);

    return 1;
}


void main( void )
{
    

  /* prompt user */
  printf("Type command\n");
  
    
  /* keep reading until the end of file is reached */
  while((Token = Get_Token(TokenStr)) != END_OF_FILE) {
    
    if (Token == ALPHA && strcmp(TokenStr,"neworder") == 0) {
      /* We got an order, read order number */
      if (Process_New_Order() == 1)
        /* Everthing went fine */
        printf("Congrats, you have processed an order\n");
      
      else {
        /* There was an error, reset scanner */
        Reset_Get_Token();
        printf("There was an error in the input. \n");
      }
    }
    else {
      /* MMM, this was not a new order, tell user */
      printf("I can only process neworder at this time. Try again\n");
      /* There was an error, reset scanner */
      Reset_Get_Token();
    }
  }
}



