#include <iostream.h>
#include <stdlib.h>

/* include the declarations for the scanner */
#include "epspscan.h"

void main( void )
  {
    token_type Token;
  
    /* Allocate the space needed for the token,
       1024 spaces seems long enough */
    char TokenStr[1024];

    /* keep reading until the end of file is reached */
    while((Token = Get_Token(TokenStr)) != END_OF_FILE) {
      switch (Token) {
      case ALPHA:
        cout << "I read an alpha token [" << TokenStr << "]\n";
        break;
      case NUMERIC:
        cout <<"I read a numeric token[" <<  atoi(TokenStr) << "]\n";
        break;
      case OTHER:
        cout << "I found something strange [" << TokenStr 
             << "]. I am reseting until the end of the line\n";
        Reset_Get_Token();
        break;
      case END_OF_LINE:
        cout << "I found the end of a line\n";
        break;
      }
    }
  }

